' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class Management_CreateUpdateBookingObject
  Inherits System.Web.UI.Page

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Not Page.IsPostBack Then
      If Request.QueryString.Get("Id") IsNot Nothing Then
        ' Wczytaj istniejcy obiekt rezerwacji z bazy danych.
        Dim myBookingObject As BookingObject = BookingObjectManager.GetBookingObject(Convert.ToInt32(Request.QueryString.Get("Id")))
        txtTitle.Text = myBookingObject.Title
        lstStartTime.SelectedHour = myBookingObject.StartTime
        lstEndTime.SelectedHour = myBookingObject.EndTime

        chkLstWorkingdays.DataBind()
        ' Sprawd kady dostpny dzie pracy w kontrolce CheckBoxList 
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Sunday) Then
          chkLstWorkingdays.Items.FindByValue("1").Selected = True
        End If
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Monday) Then
          chkLstWorkingdays.Items.FindByValue("2").Selected = True
        End If
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Tuesday) Then
          chkLstWorkingdays.Items.FindByValue("3").Selected = True
        End If
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Wednesday) Then
          chkLstWorkingdays.Items.FindByValue("4").Selected = True
        End If
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Thursday) Then
          chkLstWorkingdays.Items.FindByValue("5").Selected = True
        End If
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Friday) Then
          chkLstWorkingdays.Items.FindByValue("6").Selected = True
        End If
        If Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Saturday) Then
          chkLstWorkingdays.Items.FindByValue("7").Selected = True
        End If
        litHeading.Text = "Edytuj: " & myBookingObject.Title
      Else
        litHeading.Text = "Nowy obiekt: " & AppConfiguration.BookingObjectNameSingular
      End If
    End If
  End Sub

  Protected Sub UpdateButton_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles UpdateButton.Click
    Page.Validate()
    If Page.IsValid Then

      Dim myBookingObject As New BookingObject()
      If Request.QueryString.Get("Id") IsNot Nothing Then
        myBookingObject.Id = Convert.ToInt32(Request.QueryString.Get("Id"))
      End If
      myBookingObject.Title = txtTitle.Text
      myBookingObject.StartTime = lstStartTime.SelectedHour
      myBookingObject.EndTime = lstEndTime.SelectedHour

      For Each myItem As ListItem In chkLstWorkingdays.Items
        If myItem.Selected = True Then
          Select Case Convert.ToInt32(myItem.Value)
            Case 1 ' Niedziela - Sunday
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Sunday
            Case 2
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Monday
            Case 3
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Tuesday
            Case 4
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Wednesday
            Case 5
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Thursday
            Case 6
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Friday
            Case 7
              myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Saturday
          End Select
        End If
      Next

      BookingObjectManager.SaveBookingObject(myBookingObject)

      EndEditing()
    End If
  End Sub

  Protected Sub UpdateCancelButton_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CancelButton.Click
    EndEditing()
  End Sub

  Private Sub EndEditing()
    Response.Redirect("BookingObjects.aspx")
  End Sub
End Class
